/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EtherNetIP.h 60971 2016-05-02 12:10:47Z kai $:

Description:
  EthernetIP task diagnostic structures

**************************************************************************************/

#ifndef __ETHERNETIP_H_
#define __ETHERNETIP_H_

#ifndef __STRUCT_EIP_COMMON_STATUS_BLOCK__
#define __STRUCT_EIP_COMMON_STATUS_BLOCK__
typedef __PACKED_PRE struct __PACKED_POST EIP_COMMON_STATUS_BLOCKtag {
  UINT32 ulCommunicationCOS;
  UINT32 ulCommunicationState;
  UINT32 ulCommunicationError;
  UINT16 usVersion;
  UINT16 usWatchdogTime;
  UINT16 ausProtocolClass[2];
  UINT32 ulHostWatchdog;
  UINT32 ulErrorCount;
  UINT32 ulErrorLogInd;
  UINT32 ulReserved;
  UINT32 aulReserved[6];
} EIP_COMMON_STATUS_BLOCK;
#endif
#ifndef __STRUCT_EIP_GENERAL_STATE__
#define __STRUCT_EIP_GENERAL_STATE__
typedef __PACKED_PRE struct __PACKED_POST EIP_GENERAL_STATEtag {
  UINT32 ulError;
} EIP_GENERAL_STATE;
#endif
#ifndef __STRUCT_EIP_CODE_DIAG_T__
#define __STRUCT_EIP_CODE_DIAG_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_CODE_DIAG_Ttag {
  UINT32 ulInfoCount;
  UINT32 ulWarningCount;
  UINT32 ulErrorCount;
  UINT32 ulLevel;
  UINT32 ulCode;
  UINT32 ulParameter;
  UINT32 ulLine;
  STRING abModulName[12];
} EIP_CODE_DIAG_T;
#endif
#ifndef __STRUCT_EIP_DIAG_CMD_CNT_T__
#define __STRUCT_EIP_DIAG_CMD_CNT_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_CMD_CNT_Ttag {
  UINT32 ulNOP;
  UINT32 ulListTarget;
  UINT32 ulListIdentity;
  UINT32 ulListServices;
  UINT32 ulListInterfaces;
  UINT32 ulRegisterSession;
  UINT32 ulUnregisterSession;
  UINT32 ulProcessData;
  UINT32 ulUnknownCmd;
  UINT32 ulGoodReply;
  UINT32 ulErrorReply;
} EIP_DIAG_CMD_CNT_T;
#endif
#ifndef __STRUCT_EIP_DIAG_PROCESS_CNT_T__
#define __STRUCT_EIP_DIAG_PROCESS_CNT_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_PROCESS_CNT_Ttag {
  UINT32 ulOpenCnf;
  UINT32 ulWaitConnCnf;
  UINT32 ulConnectCnf;
  UINT32 ulUdpSendCnf;
  UINT32 ulTcpSendCnf;
  UINT32 ulCloseCnf;
  UINT32 ulSetSockOptionCnf;
  UINT32 ulReceiveInd;
  UINT32 ulStopInd;
  UINT32 ulGetCfgCnf;
  UINT32 ulShutdownInd;
  UINT32 ulSetCfgCnf;
  UINT32 ulSetCloseAllCnf;
  UINT32 ulResetReq;
  UINT32 ulRespRRReq;
  UINT32 ulSendRRReq;
  UINT32 ulSendCl3Req;
  UINT32 ulCreateTranspReq;
  UINT32 ulDelTranspReq;
  UINT32 ulStartTranspReq;
  UINT32 ulLIdnetityReq;
  UINT32 ulLInterfaceReq;
  UINT32 ulLServiceReq;
  UINT32 ulTcpCfgReq;
  UINT32 ulAbortTranspRes;
  UINT32 ulGetRRRes;
  UINT32 ulSendCl1Ind;
  UINT32 ulTranspTimeoutInd;
  UINT32 ulRequestEndInd;
  UINT32 ulMyPacketsInd;
  UINT32 ulUnknown;
} EIP_DIAG_PROCESS_CNT_T;
#endif
#ifndef __STRUCT_EIP_DIAG_OBJECT_REQ_T__
#define __STRUCT_EIP_DIAG_OBJECT_REQ_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_OBJECT_REQ_Ttag {
  UINT32 ulIdGetAttrSgl;
  UINT32 ulIdGetAttrAll;
  UINT32 ulIdReset;
  UINT32 ulIdUnknown;
  UINT32 ulAsGetAttrSgl;
  UINT32 ulAsSetAttrSgl;
  UINT32 ulAsUnknown;
  UINT32 ulCmGetAttrSgl;
  UINT32 ulCmFwOpen;
  UINT32 ulCmFwClose;
  UINT32 ulCmUnknown;
  UINT32 ulCcGetAttrSgl;
  UINT32 ulCcGetAttrAll;
  UINT32 ulCcSetAttrSgl;
  UINT32 ulCcSetAttrAll;
  UINT32 ulCcCreate;
  UINT32 ulCcDelete;
  UINT32 ulCcRestore;
  UINT32 ulCcChangeStart;
  UINT32 ulCcAuditChange;
  UINT32 ulCcChangeComplete;
  UINT32 ulCcKickTimer;
  UINT32 ulCcGetStatus;
  UINT32 ulCcUnknown;
  UINT32 ulEnGetAttrSgl;
  UINT32 ulEnGetAttrAll;
  UINT32 ulEnUnknown;
  UINT32 ulTiGetAttrSgl;
  UINT32 ulTiGetAttrAll;
  UINT32 ulTiSetAttrSgl;
  UINT32 ulTiUnknown;
} EIP_DIAG_OBJECT_REQ_T;
#endif
#ifndef __STRUCT_EIP_DIAG_OUTGOING_CONNECTION_T__
#define __STRUCT_EIP_DIAG_OUTGOING_CONNECTION_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_OUTGOING_CONNECTION_Ttag {
  UINT32 ulCcIssueOpen;
  UINT32 ulCcIssueClose;
  UINT32 ulOpenConn;
  UINT32 ulLastErrorInstance;
  UINT32 ulLastGRC;
  UINT32 ulLastERC;
} EIP_DIAG_OUTGOING_CONNECTION_T;
#endif
#ifndef __STRUCT_EIP_DIAG_INCOMING_CONNECTION_T__
#define __STRUCT_EIP_DIAG_INCOMING_CONNECTION_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_INCOMING_CONNECTION_Ttag {
  UINT32 ulLastErrorIp;
  UINT32 ulLastGRC;
  UINT32 ulLastERC;
  UINT32 ulActConnections;
} EIP_DIAG_INCOMING_CONNECTION_T;
#endif
#ifndef __STRUCT_EIP_DIAG_CONNECTION_T__
#define __STRUCT_EIP_DIAG_CONNECTION_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_CONNECTION_Ttag {
  UINT8 abData[30];
} EIP_DIAG_CONNECTION_T;
#endif
#ifndef __STRUCT_EIP_DIAG_GET_SLAVE_DIAG__
#define __STRUCT_EIP_DIAG_GET_SLAVE_DIAG__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_GET_SLAVE_DIAGtag {
  UINT32 ulState;
  UINT8 bGenStatus;
  UINT8 bReserved;
  UINT16 usExtStatus;
  UINT16 usVendorId;
  UINT16 usProductType;
  UINT16 usProductCode;
  UINT8 bMajRevision;
  UINT8 bMinRevision;
  STRING abIP[32];
  STRING abConnectionName[64];
} EIP_DIAG_GET_SLAVE_DIAG;
#endif
#ifndef __STRUCT_EIP_DIAG_APS_PACKET_CNT_T__
#define __STRUCT_EIP_DIAG_APS_PACKET_CNT_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_APS_PACKET_CNT_Ttag {
  UINT32 ulClrWdgReq;
  UINT32 ulRegAppReq;
  UINT32 ulUnRegAppReq;
  UINT32 ulWarmstartPrmReq;
  UINT32 ulChgTcpCfgReq;
  UINT32 ulRegAsCnf;
  UINT32 ulRegAsReq;
  UINT32 ulObjConnectionInd;
  UINT32 ulCyclicEventInd;
  UINT32 ulFaultInd;
  UINT32 ulGetInputReq;
  UINT32 ulSetDeviceInfoCnf;
  UINT32 ulSetDeviceInfoReq;
  UINT32 ulMrRegisterReq;
  UINT32 ulReadyCnf;
  UINT32 ulRegConnectionCnf;
  UINT32 ulResetCnf;
  UINT32 ulResetInd;
  UINT32 ulResetReq;
  UINT32 ulSetOutputReq;
  UINT32 ulTcpStartupChgInd;
  UINT32 ulWatchdogInd;
  UINT32 ulGetCommonState;
  UINT32 ulDpmIOInfoReq;
  UINT32 ulGetSlaveConnInfoReq;
  UINT32 ulGetSlaveHandleReq;
  UINT32 ulGetWdgTimeReq;
  UINT32 ulLockCfgReq;
  UINT32 ulQueLocClrCnf;
  UINT32 ulQueLocSetCnf;
  UINT32 ulRegisterAppReq;
  UINT32 ulSetWdgTimeReq;
  UINT32 ulStartStopReq;
  UINT32 ulUnRegisterAppReq;
  UINT32 ulTcpIpSetCfgCnf;
  UINT32 ulTcpIpSetCfgReq;
  UINT32 ulEndProcessReq;
  UINT32 ulInsufficientLic;
  UINT32 ulUnknown;
} EIP_DIAG_APS_PACKET_CNT_T;
#endif
#ifndef __STRUCT_EIP_DIAG_DLR_OBJECT_T__
#define __STRUCT_EIP_DIAG_DLR_OBJECT_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_DLR_OBJECT_Ttag {
  UINT8 bNetworkTopology;
  UINT8 bNetworkStatus;
  UINT8 bRingSvStatus;
  UINT8 fRingSvEnable;
  UINT8 bPrecedence;
  UINT32 ulBeaconInterval;
  UINT32 ulBeaconTimeout;
  UINT16 usVlanID;
  UINT16 usRingFaultsCount;
  UINT8 LastActiveNode1abMacAddr[6];
  UINT32 LastActiveNode1ulIPAddr;
  UINT8 LastActiveNode2abMacAddr[6];
  UINT32 LastActiveNode2ulIPAddr;
  UINT16 usParticipantsCount;
  UINT8 ActiveSuperVisorabMacAddr[6];
  UINT32 ActiveSuperVisorulIPAddr;
  UINT8 bActiveSvPrecedence;
  UINT32 ulCapabilityFlags;
  UINT8 Node1MacAddr[6];
  UINT32 Node1IPAddr;
  UINT8 Node2MacAddr[6];
  UINT32 Node2IPAddr;
  UINT8 Node3MacAddr[6];
  UINT32 Node3IPAddr;
  UINT8 Node4MacAddr[6];
  UINT32 Node4IPAddr;
  UINT8 Node5MacAddr[6];
  UINT32 Node5IPAddr;
  UINT8 Node6MacAddr[6];
  UINT32 Node6IPAddr;
  UINT8 Node7MacAddr[6];
  UINT32 Node7IPAddr;
  UINT8 Node8MacAddr[6];
  UINT32 Node8IPAddr;
  UINT8 Node9MacAddr[6];
  UINT32 Node9IPAddr;
  UINT8 Node10MacAddr[6];
  UINT32 Node10IPAddr;
} EIP_DIAG_DLR_OBJECT_T;
#endif
#ifndef __STRUCT_EIP_DIAG_DLR_COUNTER_T__
#define __STRUCT_EIP_DIAG_DLR_COUNTER_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DIAG_DLR_COUNTER_Ttag {
  /*  received frames */
  UINT16 usBcnPrecHigher;
  UINT16 usBcnRxPortNeqLast;
  UINT16 usRingStateChangedToNormal;
  UINT16 usRingStateChangedToFault;
  UINT16 usRcvdBcnFromSelfPort1;
  UINT16 usRcvdBcnFromSelfPort2;
  UINT16 usRcvdNeighborCheckReqPort1;
  UINT16 usRcvdNeighborCheckReqPort2;
  UINT16 usRcvdNeighborCheckResPort1;
  UINT16 usRcvdNeighborCheckResPort2;
  UINT16 usRcvdNeighborLinkStatus;
  UINT16 usRcvdLocateFault;
  UINT16 usRcvdAnnounceFrame;
  UINT16 usRcvdSignOn;
  UINT16 usRcvdSignOnAsUniCast;
  /*  Beacon timeouts */
  UINT16 usBcnTimeoutPort1;
  UINT16 usBcnTimeoutPort2;
  /*  sent frames */
  UINT16 usSentNeighborCheckReq;
  UINT16 usSentNeighborCheckRes;
  UINT16 usSentAnnounceFrame;
  UINT16 usSentLinkNeighborStatusFrame;
  UINT16 usForwardSignOnFrame;
  UINT16 usSentSignOnFrame;
  UINT16 usSentLocateFaultFrame;
  UINT16 usSentSignOnFrameToActiveSV;
  /*  timeouts */
  UINT16 usNeighborCheckTimeoutPort1;
  UINT16 usNeighborCheckTimeoutPort2;
  UINT16 usAnnounceIntervalTimeout;
  UINT16 usSignOnTimeout;
  /*  link changes */
  UINT16 usLinkUpPort1;
  UINT16 usLinkDownPort1;
  UINT16 usLinkUpPort2;
  UINT16 usLinkDownPort2;
  UINT16 usSetBcnIndSelf;
  UINT16 usResetBcnIndSelf;
  UINT16 usRcvdFlushTablesFrame;
  UINT16 usSentLearningUpdateFrame;
} EIP_DIAG_DLR_COUNTER_T;
#endif
#ifndef __STRUCT_EIP_EIPAPM_IO_PIN_DIAG_T__
#define __STRUCT_EIP_EIPAPM_IO_PIN_DIAG_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_EIPAPM_IO_PIN_DIAG_Ttag {
  UINT32 ulReadyPinMode;
  UINT32 ulReadyPinNumber;
  UINT32 ulReadyPinInverted;
  UINT32 ulReadyPinSet;
  UINT32 ulBusOnPinMode;
  UINT32 ulBusOnPinNumber;
  UINT32 ulBusOnPinInverted;
  UINT32 ulBusOnPinSet;
} EIP_EIPAPM_IO_PIN_DIAG_T;
#endif
#ifndef __STRUCT_EIP_DEVICE_INFO_T__
#define __STRUCT_EIP_DEVICE_INFO_T__
typedef __PACKED_PRE struct __PACKED_POST EIP_DEVICE_INFO_Ttag {
  UINT32 ulIpAddress;
  UINT16 usVendorId;
  UINT16 usDeviceType;
  UINT16 usProductCode;
  UINT8 bMajorRevision;
  UINT8 bMinorRevision;
  UINT16 usStatus;
  UINT32 ulSerialNumber;
  STRING szProductName[33];
  UINT8 bState;
} EIP_DEVICE_INFO_T;
#endif

#endif /* __ETHERNETIP_H_ */
